/////////////////////////////////////////////////////////////////////////////
// FontDlg.cpp : implementation file
// (C) Copyright G DATA Software AG 1992-2001

#include "stdafx.h"
#include "logoxapp.h"
#include "FontDlg.h"

/////////////////////////////////////////////////////////////////////////////

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFontDlg construction
/////////////////////////////////////////////////////////////////////////////

CFontDlg::CFontDlg(CWnd* pParent) : CDialog(CFontDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFontDlg)
	//}}AFX_DATA_INIT

	m_nFont = 0xFFFFFFFF;
}

void CFontDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFontDlg)
	DDX_Control(pDX, IDC_LIST, m_ctrlList);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFontDlg, CDialog)
	//{{AFX_MSG_MAP(CFontDlg)
	ON_NOTIFY(LVN_GETDISPINFO, IDC_LIST, OnGetDispInfo)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST, OnDblclkList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// slektierten Font zurckliefern
UINT CFontDlg::GetFontID()
{
	return m_nFont;
}

/////////////////////////////////////////////////////////////////////////////
// on OK, save selection
void CFontDlg::OnOK()
{
	int idx = m_ctrlList.GetSelectionMark();

	if(idx>0)
	{
		LVITEM item;
		item.mask = LVIF_PARAM;
		item.iItem = idx;

		m_ctrlList.GetItem(&item);

		m_nFont = item.lParam;
	}

	CDialog::OnOK();
}

/////////////////////////////////////////////////////////////////////////////
// WM_INITDIALOG
BOOL CFontDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_ctrlList.SetExtendedStyle(m_ctrlList.GetExtendedStyle()|LVS_EX_FULLROWSELECT);

	m_ctrlList.InsertColumn(0,_T("ID"),LVCFMT_LEFT,30);
	m_ctrlList.InsertColumn(1,_T("Description"),LVCFMT_LEFT,180);
	m_ctrlList.InsertColumn(2,_T("Alias"),LVCFMT_LEFT,100);
	m_ctrlList.InsertColumn(3,_T("Version"),LVCFMT_LEFT,60);
	m_ctrlList.InsertColumn(4,_T("Datum"),LVCFMT_LEFT,100);
	m_ctrlList.InsertColumn(5,_T("Flags"),LVCFMT_LEFT,40);
	m_ctrlList.InsertColumn(6,_T("UUID"),LVCFMT_LEFT,300);

	unsigned long nFonts = LogoxGetNumberOfFonts();
	for(unsigned long i=0;i<nFonts;i++)
	{
		LVITEM item;
		item.mask=LVIF_PARAM|LVIF_TEXT;
		item.iItem=i;
		item.iSubItem=0;
		item.pszText=LPSTR_TEXTCALLBACK;
		item.lParam=i;

		m_ctrlList.InsertItem(&item);
	}
	
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// WM_NOTIFY::NM_DBLCLK::IDC_FONT
void CFontDlg::OnDblclkList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	OnOK();
	*pResult=0;
}

/////////////////////////////////////////////////////////////////////////////
// WM_NOTIFY::LVN_GETDISPINFO::IDC_FONT
void CFontDlg::OnGetDispInfo(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;
	LV_ITEM &item = pDispInfo->item;

	switch(item.iSubItem)
	{
		case 0:
		{
			wsprintf(item.pszText,_T("%d"),item.lParam);
			break;
		}

		case 1:
		{
			LogoxGetFontName(item.lParam,item.pszText,item.cchTextMax);
			break;
		}
		
		case 2:
		{
			LogoxGetFontAlias(item.lParam,item.pszText,item.cchTextMax);
			break;
		}

		case 3:
		{
			UINT version = LogoxGetFontVersion(item.lParam);
			wsprintf(item.pszText,"%x",version);
			break;
		}

		case 4:
		{
			UINT date = LogoxGetFontDate(item.lParam);
			wsprintf(item.pszText,"%02d.%02d.%04d %02d:%02d",LOGOX_DATEDAY(date),LOGOX_DATEMONTH(date),LOGOX_DATEYEAR(date),LOGOX_DATEHOUR(date),LOGOX_DATEMIN(date));
			break;
		}
		
		case 5:
		{
			UINT flags = LogoxGetFontFlags(item.lParam);
			wsprintf(item.pszText,"%x",flags);
			break;
		}

		case 6:
		{
			unsigned char uuid[16];
			LogoxGetFontUUID(item.lParam,uuid,16);

			char v[20]={ 3,2,1,0,-1,5,4,-1,7,6,-1,8,9,-1,10,11,12,13,14,15 };
			
			char *p=item.pszText;

			int i;
			*p++='{';
			for(i=0;i<20;i++)
			{
				if(v[i]>=0)
				{
					unsigned char val=uuid[v[i]];

					char s;
					s='0'+((val>>4)&0x0F);
					if(s>'9') s+=('A'-'9')-1;
					*p++=s;
					s='0'+(val&0x0F);
					if(s>'9') s+=('A'-'9')-1;
					*p++=s;
				}
				else
				{
					*p++='-';
				}

			}

			*p++='}';
			*p=0;

			break;
		}


	}

	*pResult = 0;
}

